package gov.va.med.mhv.usermgmt.form;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;
import org.tigris.atlas.messages.Message;
import org.tigris.atlas.messages.MessageUtils;
import org.tigris.atlas.messages.Messages;
import org.tigris.atlas.util.CalendarUtils;
import org.tigris.atlas.validate.SsnValidator;
import org.tigris.atlas.validate.Validations;
import gov.va.med.mhv.core.web.util.XSSProcessor;

public class DeactivateUserForm extends DeactivateUserBaseForm {
    
    private static final Log LOG = LogFactory.getLog(UserProfileForm.class);
	
	//MHV_CodeCR1387 - Added validations for SSN, DOB and LastName+SSN
    private static final Pattern pattern = Pattern.compile(
    "^[A-Za-z][0-9][0-9][0-9][0-9]$");
	
	private String ssnFieldLevelErrorMessage;
	private String firstPlusFourErrorMessage;
	private String dateOfBirthErrorMessage;
	private String dateOfDeathErrorMessage;
	
    //Admin Portal_CodeCR1959 - React/Deact Impl
	private String deactivateNoteErrorMessage;
	private String deactivateReasonErrorMessage;
	
	
	public void setDeactivateNoteErrorMessage(String deactivateNoteErrorMessage) {
		this.deactivateNoteErrorMessage = deactivateNoteErrorMessage;
	}

	public void setDeactivateReasonErrorMessage(String deactivateReasonErrorMessage) {
		this.deactivateReasonErrorMessage = deactivateReasonErrorMessage;
	}

	public String getDeactivateNoteErrorMessage() {
		return deactivateNoteErrorMessage;
	}

	public String getDeactivateReasonErrorMessage() {
		return deactivateReasonErrorMessage;
	}

	protected void doReset(ActionMapping mapping, HttpServletRequest request) {

	}

	public String getSearchFormatSsn() {
		if (this.getUserProfileSsn() == null)
			return null;
		return this.getUserProfileSsn().replaceAll("-", "");
	}

	public String getSearchFormatBirthDate() {
		return this.getUserProfileBirthDateMonth() + "-" +
			   this.getUserProfileBirthDateDay() + "-" +
			   this.getUserProfileBirthDateYear();
	}

	public String getSearchFormatDeathDate() {
		return this.getUserProfileDeathDateMonth() + "-" +
			   this.getUserProfileDeathDateDay() + "-" +
			   this.getUserProfileDeathDateYear();
	}

    public String getFormattedDeathDateMonth() {
        String month = getUserProfileDeathDateMonth();
        try {
            return (String) CalendarUtils.getMonths().get(Integer.valueOf(
                month));
        } catch (NumberFormatException e) {
            LOG.error("Failed to parse death date month '" + month 
                + "'. Displaying unparsable value directly.", e);
            return month;
        }
    }
    
    public String getFormattedBirthDateMonth() {
        String month = getUserProfileBirthDateMonth();
        try {
            return (String) CalendarUtils.getMonths().get(Integer.valueOf(
                month));
        } catch (NumberFormatException e) {
            LOG.error("Failed to parse birth date month '" + month 
                + "'. Displaying unparsable value directly.", e);
            return month;
        }
    }

    public void setFormattedBirthDateMonth(String month) {
        // dummy method, to allow read-only text input
    }
    
    public void setFormattedDeathDateMonth(String deathDate) {
        // dummy method, to allow read-only text input
    }

	public String getPatientFlag() {
		String isPatient = this.getUserProfileIsPatient();
        if (isPatient == null)
            return "No";
	    return isPatient.equalsIgnoreCase("true") ? "Yes" : "No";
	}

	protected void additionalValidation(HttpServletRequest request) {
		cleanXSS();
		super.additionalValidation(request);
		
		if(getDeactivateReason()==null) {
			Message errMsg = MessageUtils.createErrorMessage(
                "mvi.helpdesk.invalidate.error.reason.missing", new String [] {"deactivateReason"}, null);
				getMessages().addMessage(errMsg);
		}

		if(getDeactivateNote()==null||getDeactivateNote().length()==0) {
			Message errMsg = MessageUtils.createErrorMessage(
	                "mvi.helpdesk.invalidate.error.description.missing", new String [] {"deactivateNote"}, null);
					getMessages().addMessage(errMsg);
		}
		
		setFieldLevelErrorMessages(getMessages(), request);
		setMyFieldLevelErrorMessages(getMessages(), request);
	}
	
	private void setMyFieldLevelErrorMessages(Messages messages, 
	        HttpServletRequest request) {
		if (getMessages().getErrorMessageCount("ssn") > 0) {
			Message message = (Message) messages.getErrorMessages("ssn").
            iterator().next();
			String errorString = getFieldLevelMessage(message, request);
			ssnFieldLevelErrorMessage = errorString;
		}
		
		if (getMessages().getErrorMessageCount("firstPlusFour") > 0) {
			Message message = (Message) messages.getErrorMessages("firstPlusFour").
            iterator().next();
			String errorString = getFieldLevelMessage(message, request);
			firstPlusFourErrorMessage = errorString;
		}
		
		if (getMessages().getErrorMessageCount("birthDate") > 0) {
			Message message = (Message) messages.getErrorMessages("birthDate").
            iterator().next();
			String errorString = getFieldLevelMessage(message, request);
			dateOfBirthErrorMessage = errorString;
		}

		if (getMessages().getErrorMessageCount("deactivateNote") > 0) {
			Message message = (Message) messages.getErrorMessages("deactivateNote").
            iterator().next();
			String errorString = getFieldLevelMessage(message, request);
			deactivateNoteErrorMessage = errorString;
		}
		
		if (getMessages().getErrorMessageCount("deactivateReason") > 0) {
			Message message = (Message) messages.getErrorMessages("deactivateReason").
            iterator().next();
			String errorString = getFieldLevelMessage(message, request);
			deactivateReasonErrorMessage = errorString;
		}
	}
	
	public String getSsnFieldLevelErrorMessage() {
		return ssnFieldLevelErrorMessage;
	}

	public String getFirstPlusFourErrorMessage() {
		return firstPlusFourErrorMessage;
	}
	
	public String getDateOfBirthErrorMessage() {
		return dateOfBirthErrorMessage;
	}
	
	public String getDateOfDeathErrorMessage() {
		return dateOfDeathErrorMessage;
	}
	
	private void cleanXSS() {
		setUserProfileAddressStreet1( XSSProcessor.cleanXSS( getUserProfileAddressStreet1() ) );
		setUserProfileFirstName( XSSProcessor.cleanXSS( getUserProfileFirstName() ) );
		setUserProfileAddressStreet2( XSSProcessor.cleanXSS( getUserProfileAddressStreet2() ) );
		setUserProfileAlternateAddressProvince( XSSProcessor.cleanXSS( getUserProfileAlternateAddressProvince() ) );
		setUserProfileAddressCity( XSSProcessor.cleanXSS( getUserProfileAddressCity() ) );
		setUserProfilePasswordHintAnswer1( XSSProcessor.cleanXSS( getUserProfilePasswordHintAnswer1() ) );
		setUserProfileMiddleName( XSSProcessor.cleanXSS( getUserProfileMiddleName() ) );
		setUserProfileContactInfoEmail( XSSProcessor.cleanXSS( getUserProfileContactInfoEmail() ) );
		setUserProfileAlternateAddressPostalCode( XSSProcessor.cleanXSS( getUserProfileAlternateAddressPostalCode() ) );
		setUserProfileAddressPostalCode( XSSProcessor.cleanXSS( getUserProfileAddressPostalCode() ) );
		setUserProfileContactInfoHomePhone( XSSProcessor.cleanXSS( getUserProfileContactInfoHomePhone() ) );
		setUserProfileContactInfoMobilePhone( XSSProcessor.cleanXSS( getUserProfileContactInfoMobilePhone() ) );
		setUserProfileContactInfoWorkPhone( XSSProcessor.cleanXSS( getUserProfileContactInfoWorkPhone() ) );
		setUserProfileContactInfoPager( XSSProcessor.cleanXSS( getUserProfileContactInfoPager() ) );
		setUserProfileAlternateAddressCity( XSSProcessor.cleanXSS( getUserProfileAlternateAddressCity() ) );
		setUserProfileUserAlias( XSSProcessor.cleanXSS( getUserProfileUserAlias() ) );
		setUserProfileAlternateAddressStreet1( XSSProcessor.cleanXSS( getUserProfileAlternateAddressStreet1() ) );
		setUserProfileAlternateAddressState( XSSProcessor.cleanXSS( getUserProfileAlternateAddressState() ) );
		setUserProfileSsn( XSSProcessor.cleanXSS( getUserProfileSsn() ) );
		setUserProfileAddressProvince( XSSProcessor.cleanXSS( getUserProfileAddressProvince() ) );
		setUserProfileAlternateAddressCountry( XSSProcessor.cleanXSS( getUserProfileAlternateAddressCountry() ) );
		setUserProfileAlternateAddressStreet2( XSSProcessor.cleanXSS( getUserProfileAlternateAddressStreet2() ) );
		setUserProfileLastName( XSSProcessor.cleanXSS( getUserProfileLastName() ) );
		setUserProfilePasswordHintAnswer2( XSSProcessor.cleanXSS( getUserProfilePasswordHintAnswer2() ) );
		setUserProfileCurrentOccupation( XSSProcessor.cleanXSS( getUserProfileCurrentOccupation() ) );
		setUserProfileContactInfoFax( XSSProcessor.cleanXSS( getUserProfileContactInfoFax() ) );
		setUserName( XSSProcessor.cleanXSS( getUserName() ) );
		//Admin Portal_CodeCR1959 - React/Deact Impl
		setDeactivateNote( XSSProcessor.cleanXSS( getDeactivateNote()) );
		//setUserProfileIsHealthCareProvider( XSSProcessor.cleanXSS( getUserProfileIsHealthCareProvider() ) );
		//setUserProfileInterestHeart( XSSProcessor.cleanXSS( getUserProfileInterestHeart() ) );
		//setUserProfileIsEmployee( XSSProcessor.cleanXSS( getUserProfileIsEmployee() ) );
		//setUserProfileIsPatientAdvocate( XSSProcessor.cleanXSS( getUserProfileIsPatientAdvocate() ) );
		//setUserProfileInterestStress( XSSProcessor.cleanXSS( getUserProfileInterestStress() ) );
		//setUserProfileInterestPTSD( XSSProcessor.cleanXSS( getUserProfileInterestPTSD() ) );
		//setUserProfileContactInfoContactMethod( XSSProcessor.cleanXSS( getUserProfileContactInfoContactMethod() ) );
		//setUserProfileInterestDepression( XSSProcessor.cleanXSS( getUserProfileInterestDepression() ) );
		//setUserProfileEmailHealthAwareness( XSSProcessor.cleanXSS( getUserProfileEmailHealthAwareness() ) );
		//setUserProfileAddressCountry( XSSProcessor.cleanXSS( getUserProfileAddressCountry() ) );
		//setUserProfilePasswordHintQuestion1( XSSProcessor.cleanXSS( getUserProfilePasswordHintQuestion1() ) );
		//setUserProfileGender( XSSProcessor.cleanXSS( getUserProfileGender() ) );
		//setUserProfileInterestDiabetes( XSSProcessor.cleanXSS( getUserProfileInterestDiabetes() ) );
		//setUserProfileInterestSmoking( XSSProcessor.cleanXSS( getUserProfileInterestSmoking() ) );
		//setUserProfileIsPatient( XSSProcessor.cleanXSS( getUserProfileIsPatient() ) );
		//setUserProfileBloodType( XSSProcessor.cleanXSS( getUserProfileBloodType() ) );
		//setUserProfileTitle( XSSProcessor.cleanXSS( getUserProfileTitle() ) );
		//setUserProfileMaritalStatus( XSSProcessor.cleanXSS( getUserProfileMaritalStatus() ) );
		//setUserProfileInterestExercise( XSSProcessor.cleanXSS( getUserProfileInterestExercise() ) );
		//setUserProfileInterestAlcohol( XSSProcessor.cleanXSS( getUserProfileInterestAlcohol() ) );
		//setUserProfileInterestReminder( XSSProcessor.cleanXSS( getUserProfileInterestReminder() ) );
		//setUserProfileIsOrganDonor( XSSProcessor.cleanXSS( getUserProfileIsOrganDonor() ) );
		//setUserProfileIsAdministrator( XSSProcessor.cleanXSS( getUserProfileIsAdministrator() ) );
		//setUserProfileSuffix( XSSProcessor.cleanXSS( getUserProfileSuffix() ) );
		//setUserProfilePasswordHintQuestion2( XSSProcessor.cleanXSS( getUserProfilePasswordHintQuestion2() ) );
		//setUserProfileAcceptTerms( XSSProcessor.cleanXSS( getUserProfileAcceptTerms() ) );
		//setUserProfileAcceptSMTerms( XSSProcessor.cleanXSS( getUserProfileAcceptSMTerms() ) );
		//setUserProfileAcceptDisclaimer( XSSProcessor.cleanXSS( getUserProfileAcceptDisclaimer() ) );
		//setUserProfileInterestMilitaryRelated( XSSProcessor.cleanXSS( getUserProfileInterestMilitaryRelated() ) );
		//setUserProfileIsVeteran( XSSProcessor.cleanXSS( getUserProfileIsVeteran() ) );
		//setUserProfileAddressState( XSSProcessor.cleanXSS( getUserProfileAddressState() ) );
		//setUserProfileBirthDateMonth( XSSProcessor.cleanXSS( getUserProfileBirthDateMonth() ) );
		//setUserProfileBirthDateDay( XSSProcessor.cleanXSS( getUserProfileBirthDateDay() ) );
		//setUserProfileBirthDateYear( XSSProcessor.cleanXSS( getUserProfileBirthDateYear() ) );
		//setUserProfileAcceptPrivacy( XSSProcessor.cleanXSS( getUserProfileAcceptPrivacy() ) );
		//setUserProfileInterestDiet( XSSProcessor.cleanXSS( getUserProfileInterestDiet() ) );
		//setUserProfileInterestBloodPressure( XSSProcessor.cleanXSS( getUserProfileInterestBloodPressure() ) );
		//setUserProfileIsOther( XSSProcessor.cleanXSS( getUserProfileIsOther() ) );

		//mhvId;
		//password;
		//confirmPassword;
		//ssn1;
		//ssn2;
		//ssn3;
		//verifySsn1;
		//verifySsn2;
		//verifySsn3;
		//firstPlusFour;
		//relationshipToVA;
	}
}

